<?php

namespace Fir\Models;

class Admin extends Model {

    /**
     * @var string
     */
    public $username;

    /**
     * @var string
     */
    public $password;

    /**
     * @var string
     */
    public $rememberToken;
	
    /**
     * Update the Admin Profile Details
     *
     */
    public function profileDetails($name, $username, $email, $adminid) {

		$Update = $this->db->update('admin',[
		   'name' => $name,
		   'username' => $username,
		   'email' => $email,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }
	
    /**
     * Update the Admin Profile Image
     *
     */
    public function profileImage($filename, $adminid) {

		$Update = $this->db->update('admin',[
		   'imagelocation' => $filename,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }	
	
    /**
     * Update the Admin Panel Password
     *
     */
    public function password($password, $adminid) {

		$Update = $this->db->update('admin',[
		   'password' => $password,
		],[
		    'adminid' => $adminid
		  ]);
		  
		return $Update->rowCount();  
    }
    
    public function count_categories() {
	   $no = $this->db->count("categories", []); 
	   return $no;
    }	
    public function count_voters() {
	   $no = $this->db->count("user", ["user_type" => 1]); 
	   return $no;
    }	
    public function count_candidates() {
	   $no = $this->db->count("user", ["user_type" => 2]); 
	   return $no;
    }    
    public function has_start() {
	   $no = $this->db->has('start', []); 
	   return $no;
    }   
    public function start() {
	   $no = $this->db->select('start', '*', ["LIMIT" => 1, "ORDER" =>["id" => "DESC"]]); 
	   return $no;
    }   
    public function start_array() {
	   $start_array = $this->db->select('start', '*', ["LIMIT" => 1, "ORDER" =>["id" => "DESC"]]);
       foreach ($start_array as $start) {}
	   return $start;
    }    
    public function update_voting($title, $date_to_start, $date_to_end, $description, $id) {

		$Update = $this->db->update('start',[
		   'title' => $title,
		   'date_to_start' => $date_to_start,
		   'date_to_end' => $date_to_end,
		   'description' => $description,
		],[
		    'id' => $id
		  ]);
		  
		return $Update->rowCount();  
    }
    public function start_voting($title, $date_to_start, $date_to_end, $description) {
		
	    $Insert = $this->db->insert('start', array(
		   'title' => $title,
		   'date_to_start' => $date_to_start,
		   'date_to_end' => $date_to_end,
		   'description' => $description
		));	
		  
		return $Insert->rowCount();  
    }	

}